
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

set (path "/a//d")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "/a/b/c")
if (NOT path STREQUAL "../../d")
  list (APPEND errors "'${path}' instead of '../../d'")
endif()

set (path "/a//b///c")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "/a/d")
if (NOT path STREQUAL "../b/c")
  list (APPEND errors "'${path}' instead of '../b/c'")
endif()

set (path "a/b/c")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "a")
if (NOT path STREQUAL "b/c")
  list (APPEND errors "'${path}' instead of 'b/c'")
endif()

set (path "a/b/c")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "a/b/c/x/y")
if (NOT path STREQUAL "../..")
  list (APPEND errors "'${path}' instead of '../..'")
endif()

set (path "a/b/c")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "a/b/c")
if (NOT path STREQUAL ".")
  list (APPEND errors "'${path}' instead of '.'")
endif()

set (path "a/b")
cmake_path(RELATIVE_PATH path BASE_DIRECTORY "c/d")
if (NOT path STREQUAL "../../a/b")
  list (APPEND errors "'${path}' instead of '../../a/b'")
endif()

set (path "${CMAKE_CURRENT_SOURCE_DIR}/../../b")
cmake_path(RELATIVE_PATH path)
if (NOT path STREQUAL "../../b")
  list (APPEND errors "'${path}' instead of '../../b'")
endif()

set (path "${CMAKE_CURRENT_SOURCE_DIR}/../../b")
cmake_path(RELATIVE_PATH path OUTPUT_VARIABLE output)
if (NOT path STREQUAL "${CMAKE_CURRENT_SOURCE_DIR}/../../b")
  list (APPEND errors "input changed unexpectedly")
endif()
if (NOT output STREQUAL "../../b")
  list (APPEND errors "'${output}' instead of '../../b'")
endif()

if (WIN32)
  set (path "/a/d")
  cmake_path(RELATIVE_PATH path BASE_DIRECTORY "e/d/c")
  if (NOT path STREQUAL "/a/d")
    list (APPEND errors "'${path}' instead of '/a/d'")
  endif()

  set (path "c:/a/d")
  cmake_path(RELATIVE_PATH path BASE_DIRECTORY "e/d/c")
  if (NOT path STREQUAL "")
    list (APPEND errors "'${path}' instead of ''")
  endif()
elseif()
  set (path "/a/d")
  cmake_path(RELATIVE_PATH path BASE_DIRECTORY "e/d/c")
  if (NOT path STREQUAL "")
    list (APPEND errors "'${path}' instead of ''")
  endif()
endif()

check_errors (RELATIVE_PATH ${errors})
